#!/bin/bash

hidVids=("811e" "4348", "1915")
hidPids=("8846" "5537", "520f")

filename='/etc/udev/rules.d/ilab.rules'

if ! command -v udevadm &> /dev/null
then
    echo "udevadm command not found. Aborting."
    exit 1
fi

if [ -f "$filename" ]; then
  if ! rm "$filename"; then
    echo "Failed to remove existing file $filename. Aborting."
    exit 1
  fi
fi

if ! touch "$filename"; then
  echo "Failed to create file $filename. Aborting."
  exit 1
fi

len=${#hidVids[@]}
for ((i=0; i<len; i++)); do
  echo "SUBSYSTEM==\"usb\", ATTRS{idVendor}==\"${hidVids[$i]}\", ATTRS{idProduct}==\"${hidPids[$i]}\", MODE:=\"0666\"" >> "$filename";
done

echo "" >> "$filename";

if ! udevadm control --reload-rules; then
  echo "Failed to reload udev rules. Aborting."
  exit 1
fi

if ! udevadm trigger; then
  echo "Failed to trigger udev events. Aborting."
  exit 1
fi

echo "USB Подключение успешно настроено"
exit 0

