#!/bin/bash
clear
echo "Сборка и установка драйвера для блютуз адаптера"
echo "Начало сборки. Нам потребуется стабильное интернет соединение"
sleep 1s
if [ !"$(uname -r)" = "5.4.0-110-generic" ]; then
       echo "Данное ядро не поддерживается. Пожалуйста обновите модификацию ядра до 5.4.0-110";
    exit 1;
}
fi
echo "Установка необходимых компонентов"
sudo apt-get update -y
sudo apt dist-upgrade -y
sudo apt install build-essential git flex bison libssl-dev libelf-dev software-properties-common libfuse2 glibc-source -y
#install rfkill
sudo apt install rfkill -y
#install blueman
sudo apt install blueman -y
sudo apt install bluez -y

tar -xvf blueDrivers.tar.xz
wget -P blueDrivers https://raw.githubusercontent.com/Realtek-OpenSource/android_hardware_realtek/rtk1395/bt/rtkbt/Firmware/BT/rtl8761b_config
wget -P blueDrivers https://raw.githubusercontent.com/Realtek-OpenSource/android_hardware_realtek/rtk1395/bt/rtkbt/Firmware/BT/rtl8761b_fw

clear
echo "Распаковка файлов"
sleep 5s
sudo apt install xz-utils
cd blueDrivers/pulledUbuntu/     +changedirs to astra
patch -l -p 1 < v2-1-1-Bluetooth-btrtl-Add-support-for-RTL8761B.diff

clear
echo "Резервное копирование старых драйверов BT"
sleep 3s
sudo cp -vr /lib/modules/$(uname -r)/kernel/drivers/bluetooth ~/bluetooth.old
echo "Сборка новых драйверов, это займет несколько минут..."
make oldconfig
make prepare
make scripts

clear
cd drivers/bluetooth
make -C /lib/modules/$(uname -r)/build M=$(pwd) modules
sudo cp *.ko /lib/modules/$(uname -r)/kernel/drivers/bluetooth

+delete all set files
echo "Все готово! пожалуйста перезагрузите операционную систему"

exit 0
